*Title: Creating an Invoice
*Slug: creating-invoice
*Answers Common Question: How can I issue an Invoice to my client?

================================================================

The simplest way to create an Invoice is to use the <{option}>New Invoice<{/option}> form in the <{term}>Invoices<{/term}> section.

When filling out the form, you can use existing data stored in activeCollab, such as the Client Company details, Currency settings, Languages, Tax Rates, etc. On top of that, you can use the <{option}>Invoice Item Templates<{/option}> and <{option}>Note Templates<{/option}> to speed up the process.

<{note title="How to set up Item and Note Templates?"}> To create a new **Invoice Item Template**, open <{option}>Administration > Item Templates > New Invoice Item Template<{/option}>. You can set the Description, Price and Quantity, as well as Taxes that should be applied to each item. You can use this setup to create templates for the services, or products that you are selling. 

**Note Templates** can be set in the same way by opening <{option}>Administration > Note Templates > New Note Template<{/option}>. Use this type of templates to provide additional information for you clients, such as the taxes that they need to pay or additional payment terms and conditions. It is also possible to set a note as default, if necessary.<{/note}>

<{image name="invoice_form.png"}>

Once you have created the Invoice, you can email it to your client. The Invoice is  delivered as a **PDF attachment**. If you enable your client to <{option}>Receive and Pay Invoices<{/option}> (an additional permission in their <{page name="system-roles" book="people"}>System Role<{/page}> setup), they will be able to access their the Invoice section after logging in to activeCollab. In this case, **your <{term}>Clients<{/term}> will only see Invoices issued to their company**.

You can go even further and help your Clients submit a payment right away by <{page name="payment-gateway"}>setting up a Payment Gateway<{/page}> in your activeCollab.

<{sub}>Creating an Invoice from a Task<{/sub}>

When tracking time against a <{term}>Task<{/term}>, you can easily create an Invoice from the time logs on that Task.

If there are any <{term}>Billable<{/term}> time logs available, you will be able to click the <{option}>Create Invoice<{/option}> button on the Task header or by opening <{option}>Options > Create Invoice<{/option}> menu. 

<{note title="Will I see a Task name on my Invoices when creating Invoice from a Task?"}>Yes, you have the option to choose how exactly you wish to group <{term}>Invoice Items<{/term}> when creating and Invoice from Task, Milestone, Project, or <{page name="creating-invoice-from-time-report"}>Time Report<{/page}>.

The following time record layout options are available:

- **Separate Invoice Items** - displays every logged time entry in the Invoice.
- Group by **Task** - displays the Task name and the amount of logged time per Task.
- Group by **Project** - displays a sum of all time entries under the Project name.
- Group by **Job Type** - displays the number of hours logged for a specific Job Type.
- Sum All Time Records as a **Single Invoice Item**.

On top of that, you can choose the format that you wish to have your <{term}>Invoice Items<{/term}> displayed.<{/note}>


<{sub}>Creating an Invoice from a Milestone<{/sub}>

In case you have tracked time for one or more Tasks related to a specific <{term}>Milestone<{/term}> you can create an Invoice from that Milestone.

Open the Milestone details and click <{option}>Options > Create Invoice<{/option}> to generate a new Invoice. Please note that only time records with the status <{term}>Billable<{/term}> are available when creating an Invoice. If there are no such records, the <{option}>Create Invoice<{/option}> option will not be available. 

<{sub}>Creating an Invoice from a Project<{/sub}>

To create an Invoice from an entire Project, open the <{term}>Project Overview<{/term}> page and click <{option}>Options > Create Invoice<{/option}>. This option will be available only if you have time logs which have not yet been included in any other Invoice.

If you choose to create an Invoice in this way, the Project name will be visible in the Invoice as a reference to your work.

Another way to refer to a Project when creating an Invoice, is to select to have Project name displayed when you are selecting how the Invoice Items will be displayed.

<{image name="project_invoice_zoom.png"}>